//+------------------------------------------------------------------+
//|                                Custom Indicators test script.mq5 |
//|                                          Copyright 2023, Omegafx |
//|                                           https://www.omegafx.co |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, Omegafx"
#property link      "https://www.mql5.com/en/users/omegajoctan/seller"
#property version   "1.00"

#include <ta-lib.mqh>
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  { 
    /* 
     vector prices = {1,2,3,4,5,6,7,8,9,10};
     int period = 3;

//--- Trend following
    
     Print("SMA values: ", CTrendIndicators::SMA(prices, period)); 
     Print("EMA values: ", CTrendIndicators::EMA(prices, period)); 
     
     vector close = {1,2,3,4,5,6,7,8,9,10};
     vector high = {1.5,2.5,3.5,4.5,5.5,6.5,7.5,8.5,9.5,10.5};
     vector low = {0.5,1.5,2.5,3.5,4.5,5.5,6.5,7.5,8.5,9.5};
     
     Print("Parabolic SAR values: ", CTrendIndicators::ParabolicSAR(high,low,close,0.02,0.2)); 
     
     
     
     BB_res_struct bb;
     
     bb = CTrendIndicators::BollingerBands(prices,period,0,2);
     
     Print("BB upper: ",bb.upper_band);
     Print("BB middle: ",bb.middle_band);
     Print("BB lower: ",bb.lower_band);
     
     Print("Stddev values: ", CTrendIndicators::StandardDeviation(prices, period)); 
     
//--- Oscillators
     
     MACD_res_struct macd;
     
     macd = COscillatorIndicators::MACD(prices,2,3,4);
     
     Print("MACD main: ", macd.main); 
     Print("MACD signal: ", macd.signal); 
     
     
     Print("RSI values: ", COscillatorIndicators::RSI(prices,period)); 
     
     
     Stochastic_struct stoch;
     
     stoch = COscillatorIndicators::StochasticOscillator(high,low,close,5,3,3);
     
     Print("Stoch main: ", stoch.main); 
     Print("Stoch signal: ", stoch.signal); 
     
     Print("ATR values: ", COscillatorIndicators::ATR(high,low,close,3)); 
     
//--- Bill williams indicator
    
     Print("AO values: ", CBillWilliamsIndicators::AwesomeOscillator(high,low,3,5)); 
     Print("AC values: ", CBillWilliamsIndicators::AcceleratorOscillator(high,low,3,5)); 
    */
    
    int size = 1000;
    
    vector open, high, low, close;
    open.CopyRates(Symbol(), Period(), COPY_RATES_OPEN, 1, size);
    high.CopyRates(Symbol(), Period(), COPY_RATES_HIGH, 1, size);
    low.CopyRates(Symbol(), Period(), COPY_RATES_LOW, 1, size);
    close.CopyRates(Symbol(), Period(), COPY_RATES_CLOSE, 1, size);
    
    
    matrix Indicators(size, 8);
    
    Indicators.Col(CTrendIndicators::SMA(open, 20), 0);
    Indicators.Col(CTrendIndicators::SMA(high, 50), 1);
    Indicators.Col(CTrendIndicators::SMA(low, 100), 2);
    Indicators.Col(CTrendIndicators::SMA(close, 20), 3);
    Indicators.Col(COscillatorIndicators::MomentumIndicator(open, 20), 4);
    Indicators.Col(COscillatorIndicators::MomentumIndicator(high, 50), 5);
    Indicators.Col(COscillatorIndicators::MomentumIndicator(low, 100), 6);
    Indicators.Col(COscillatorIndicators::MomentumIndicator(close, 20), 7);
    
    Print("Indicators matrix\n",Indicators);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool WriteCsv(string csv_name, matrix &matrix_, string header_string="",bool common=false)
  {
   FileDelete(csv_name);
   int handle = FileOpen(csv_name,FILE_WRITE|FILE_CSV|FILE_ANSI|(common?FILE_COMMON:FILE_ANSI),",",CP_UTF8);
   
   if (header_string == "" || header_string == NULL)
     for (ulong i=0; i<matrix_.Cols(); i++)
       header_string += "None"+ (i==matrix_.Cols()-1?"":","); 

   if(handle == INVALID_HANDLE)
     {
       printf("Invalid %s handle Error %d ",csv_name,GetLastError());
       return (false);
     }
            
   string concstring;
   vector row = {};
   
   string header[];
   
   ushort u_sep;
   u_sep = StringGetCharacter(",",0);
   StringSplit(header_string,u_sep, header);
   
   vector colsinrows = matrix_.Row(0);
   
   if (ArraySize(header) != (int)colsinrows.Size())
      {
         printf("headers=%d and columns=%d from the matrix vary is size ",ArraySize(header),colsinrows.Size());
         return false;
      }

//---

   string header_str = "";
   for (int i=0; i<ArraySize(header); i++)
      header_str += header[i] + (i+1 == colsinrows.Size() ? "" : ",");
   
   FileWrite(handle,header_str);
   
   FileSeek(handle,0,SEEK_SET);
   
   for(ulong i=0; i<matrix_.Rows() && !IsStopped(); i++)
     {
      ZeroMemory(concstring);

      row = matrix_.Row(i);
      for(ulong j=0, cols =1; j<row.Size() && !IsStopped(); j++, cols++)
         concstring += (string)NormalizeDouble(row[j],8) + (cols == matrix_.Cols() ? "" : ",");

      FileSeek(handle,0,SEEK_END);
      FileWrite(handle,concstring);
     }
        
   FileClose(handle);
   
   return (true);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
